// CodeBreakerView.cpp : implementation of the CCodeBreakerView class
//
#include "stdafx.h"
#include "vld.h"
#include "CodeBreaker.h"

#include "CodeBreakerDoc.h"
#include "CodeBreakerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CCodeBreakerView

IMPLEMENT_DYNCREATE(CCodeBreakerView, CFormView)

BEGIN_MESSAGE_MAP(CCodeBreakerView, CFormView)
	ON_WM_CREATE()

	ON_BN_CLICKED(IDC_BUTTON1, &CCodeBreakerView::OnGenerate)
	ON_BN_CLICKED(IDC_BUTTON2, &CCodeBreakerView::OnSolve)
	ON_BN_CLICKED(IDC_BUTTON3, &CCodeBreakerView::OnScript)
	
	ON_BN_CLICKED(IDC_CHECK1, &CCodeBreakerView::OnSlovnik)

END_MESSAGE_MAP()

// CCodeBreakerView construction/destruction

CCodeBreakerView::CCodeBreakerView()
	: CFormView(CCodeBreakerView::IDD),
	data(&status)
{
	// TODO: add construction code here
	slovnik = false;
}

CCodeBreakerView::~CCodeBreakerView()
{
}

void CCodeBreakerView::DoDataExchange(CDataExchange* pDX)
{
	DDX_Control(pDX, IDC_EDIT2, letters);
	DDX_Control(pDX, IDC_EDIT3, code);
	DDX_Control(pDX, IDC_EDIT4, status);
	DDX_Control(pDX, IDC_EDIT5, num_grams);
	DDX_Control(pDX, IDC_EDIT6, solution);
	DDX_Control(pDX, IDC_EDIT7, num_all);
	DDX_Control(pDX, IDC_EDIT8, num_words);
	DDX_Control(pDX, IDC_EDIT9, value_word);
	DDX_Control(pDX, IDC_EDIT10, many);
	DDX_Control(pDX, IDC_COMBO1, ngrams);
	DDX_Control(pDX, IDC_COMBO2, prefix);

	ngrams.AddString(_T("1"));
	ngrams.AddString(_T("2"));
	ngrams.AddString(_T("3"));
	ngrams.AddString(_T("4"));
	ngrams.AddString(_T("5"));
	ngrams.AddString(_T("6"));
	ngrams.SetCurSel(3);

	many.SetWindowText(_T("20"));

	prefix.AddString(_T("Prefix 3"));
	prefix.AddString(_T("Prefix 4"));
	prefix.AddString(_T("Prefix 5"));
	prefix.AddString(_T("Prefix 6"));
	prefix.AddString(_T("Prefix 7"));
	prefix.AddString(_T("Prefix 8"));
	prefix.SetCurSel(3);
	prefix.EnableWindow(false);

	value_word.SetWindowText(_T("900"));
	value_word.EnableWindow(false);
	
	status.SetWindowText(_T("Nenatan korpus"));
	letters.SetWindowText(_T("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
	num_grams.SetWindowText(_T("0"));
	num_words.SetWindowText(_T("0"));
	num_all.SetWindowText(_T("0 / 0"));

	CPerm perm(26);
	perm.Generate();
	CString sifra;
	sifra = _T("AhojJaSomJednoduchaSubstitucnaSifraKtoruVieTentoProgramVyriesitPopisemEsteAkoToVyzeraUNasDomaSedimeJaBabkaAMamaAKazdyZNasCitaNovinyToPretoLeboChcemeBytVzdeleneNieVzdyToTakAleFungujeNiekedyPrideNaNavstevuInaSifraAVtedyZacnePoriadnaHadkaOTomKtoJeNajbezpecnejsiMyMameVacsinouSlabeArgumentyAleUzSmeParKratAjVyhraliTaktoToChodiUNasDoma");
	sifra.MakeUpper();

	code.SetWindowText(perm.GetString(sifra, _T("ABCDEFGHIJKLMNOPQRSTUVWXYZ")));

	CFormView::DoDataExchange(pDX);
}

BOOL CCodeBreakerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs


	cs.hMenu = 0;

	return CFormView::PreCreateWindow(cs);
}

void CCodeBreakerView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();
}


int CCodeBreakerView::OnCreate(LPCREATESTRUCT cs)
{
	return 0;
}

void CCodeBreakerView::OnGenerate()
{
	CString str;
	letters.GetWindowText(str);
	data.SetupLetters(str);
	ngrams.EnableWindow(false);

	int i = data.LoadFromDir(_T("inputs\\*.*"), ngrams.GetCurSel()+1);
	
	str.Format(_T("Natanch %d sborov."), i);
	if (i > 0) status.SetWindowText(str);

	str.Format(_T("%d"), data.gr_all);
	num_grams.SetWindowText(str);

	str.Format(_T("%d"), data.num_words);
	num_words.SetWindowText(str);

	str.Format(_T("%d / %d"), data.gr_length-data.gr_empty, data.gr_length);
	num_all.SetWindowText(str);

	MessageBeep(1);
}

void CCodeBreakerView::OnSolve()
{
	CString str, str2;
	code.GetWindowText(str);

	if (data.gr_all == 0 || str.GetLength() == 0) {
		status.SetWindowText(_T("Chyba - nezadan ifra alebo 0 vytvorench gramov."));
		return ;
	}

	double d;

	
	int i = 0, j = 0;
	value_word.GetWindowText(str2);
	while (j < str2.GetLength()) {
		if (str2[j] >= '0' && str2[j] <= '9') {
			i *= 10;
			i += str2[j] - '0'; 
		}
		j++;
	}

	j = 0;
	int k = 0;
	many.GetWindowText(str2);
	while (j < str2.GetLength()) {
		if (str2[j] >= '0' && str2[j] <= '9') {
			k *= 10;
			k += str2[j] - '0'; 
		}
		j++;
	}
	
	CString sol = data.Solve(str, k, (slovnik ? i : 0));
	//str.Format(_T("%.2lf %%"), sol*100);
	
	str = _T("");
	for (int i=0; i<10; i++) {
		str2 = data.GetResult(i, &d);
		str += str2;
		str2.Format(_T("\r\n%.0lf "), d);
		str += str2;
		letters.GetWindowText(str2);
		str += _T("K: ") + data.perm_res[i]->GetPerm(str2);
		str += _T(" \r\n\r\n");
	}
	
	//data.OutputToFile(_T("output.txt"));

	solution.SetWindowText(str);

//	str = _T("BYVALISMEVDOM");
//	int g = data.FindWords(NULL, &str, 0);
	MessageBeep(1);
}

void CCodeBreakerView::OnScript()
{
	//data.ConcatFiles(_T("outputs\\allR_g6iNm50r20.txt"), _T("outputs\\outR_g6iNw???m50r20.txt"));

	data.DoScript(_T("script.txt"));
	//data.DoScript(_T("input.txt"), true);
	//data.DoScript(_T("randscript.txt"), false);

	CString str;

	str.Format(_T("%d"), data.gr_all);
	num_grams.SetWindowText(str);

	str.Format(_T("%d / %d"), data.diff_words, data.num_words);
	num_words.SetWindowText(str);

	str.Format(_T("%d / %d"), data.gr_length-data.gr_empty, data.gr_length);
	num_all.SetWindowText(str);
	MessageBeep(1);
}

void CCodeBreakerView::OnSlovnik()
{
	slovnik = !slovnik;
	value_word.EnableWindow(slovnik);
	prefix.EnableWindow(slovnik);
}


// CCodeBreakerView diagnostics

#ifdef _DEBUG
void CCodeBreakerView::AssertValid() const
{
	CFormView::AssertValid();
}

void CCodeBreakerView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CCodeBreakerDoc* CCodeBreakerView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCodeBreakerDoc)));
	return (CCodeBreakerDoc*)m_pDocument;
}
#endif //_DEBUG


